
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='diapers', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='toilet paper rolls', vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='candles', vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name='rubber gloves', vtype=gurobi.GRB.INTEGER)
x5 = m.addVar(name='dish soap bottles', vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(2*x1 + 5*x2 + 8*x3 + 6*x4 + 5*x5, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 <= 216)
m.addConstr(2*x2 <= 216)
m.addConstr(11*x3 <= 216)
m.addConstr(11*x4 <= 216)
m.addConstr(12*x5 <= 216)
m.addConstr(2*x2 + 11*x3 >= 26)
m.addConstr(3*x1 + 11*x4 >= 43)
m.addConstr(11*x3 + 11*x4 >= 16)
m.addConstr(11*x3 + 12*x5 >= 39)
m.addConstr(2*x2 + 12*x5 >= 31)
m.addConstr(2*x2 + 11*x4 >= 40)
m.addConstr(3*x1 + 2*x2 >= 20)
m.addConstr(2*x2 + 11*x3 <= 121)
m.addConstr(3*x1 + 2*x2 <= 100)
m.addConstr(3*x1 + 11*x3 <= 62)
m.addConstr(3*x1 + 2*x2 + 11*x4 <= 88)
m.addConstr(3*x1 + 11*x4 + 12*x5 <= 179)
m.addConstr(3*x1 + 2*x2 + 12*x5 <= 69)
m.addConstr(3*x1 + 2*x2 + 11*x3 <= 152)
m.addConstr(2*x2 + 11*x3 + 12*x5 <= 150)
m.addConstr(3*x1 + 2*x2 + 11*x3 + 11*x4 + 12*x5 <= 150)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Diapers: ', x1.varValue)
    print('Toilet paper rolls: ', x2.varValue)
    print('Candles: ', x3.varValue)
    print('Rubber gloves: ', x4.varValue)
    print('Dish soap bottles: ', x5.varValue)
else:
    print('The model is infeasible')
