
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
apple_pies = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")
cornichons = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cornichons")
protein_bars = m.addVar(lb=0, vtype=GRB.INTEGER, name="protein_bars")
slices_of_pizza = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="slices_of_pizza")


# Set objective function
m.setObjective(9*apple_pies**2 + 3*apple_pies*cornichons + apple_pies*slices_of_pizza + 8*cornichons*protein_bars + protein_bars**2 + 9*slices_of_pizza**2 + 7*cornichons + 3*protein_bars + 2*slices_of_pizza, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*protein_bars**2 + 9*slices_of_pizza**2 >= 14)
m.addConstr(10*cornichons + 9*protein_bars + 9*slices_of_pizza >= 14)
m.addConstr(10*apple_pies + 9*protein_bars + 9*slices_of_pizza >= 14)
m.addConstr(10*apple_pies + 10*cornichons + 9*slices_of_pizza >= 14)
m.addConstr(10*cornichons + 9*protein_bars + 9*slices_of_pizza >= 21)
m.addConstr(10*apple_pies + 9*protein_bars + 9*slices_of_pizza >= 21)
m.addConstr(10*apple_pies + 10*cornichons + 9*slices_of_pizza >= 21)
m.addConstr(10*cornichons + 9*protein_bars + 9*slices_of_pizza >= 21)
m.addConstr(10*apple_pies + 9*protein_bars + 9*slices_of_pizza >= 21)
m.addConstr(10*apple_pies + 10*cornichons + 9*slices_of_pizza >= 21)
m.addConstr(7*protein_bars**2 + 6*slices_of_pizza**2 >= 19)
m.addConstr(8*apple_pies + 7*protein_bars >= 14)
m.addConstr(11*cornichons + 7*protein_bars + 6*slices_of_pizza >= 21)
m.addConstr(4*protein_bars + slices_of_pizza >= 13)
m.addConstr(10*cornichons**2 + 9*slices_of_pizza**2 <= 56)
m.addConstr(10*apple_pies + 10*cornichons <= 63)
m.addConstr(10*cornichons**2 + 9*protein_bars**2 <= 53)
m.addConstr(10*apple_pies + 10*cornichons + 9*protein_bars + 9*slices_of_pizza <= 53)
m.addConstr(8*apple_pies + 7*protein_bars <= 77)
m.addConstr(11*cornichons + 6*slices_of_pizza <= 28)
m.addConstr(8*apple_pies**2 + 11*cornichons**2 <= 58)
m.addConstr(7*protein_bars**2 + 6*slices_of_pizza**2 <= 81)
m.addConstr(8*apple_pies + 11*cornichons + 7*protein_bars + 6*slices_of_pizza <= 81)
m.addConstr(4*cornichons + 4*protein_bars <= 78)
m.addConstr(4*protein_bars + slices_of_pizza <= 43)
m.addConstr(5*apple_pies + slices_of_pizza <= 63)
m.addConstr(4*cornichons + slices_of_pizza <= 25)
m.addConstr(5*apple_pies**2 + 4*protein_bars**2 <= 85)
m.addConstr(5*apple_pies**2 + 4*protein_bars**2 + slices_of_pizza**2 <= 68)
m.addConstr(4*cornichons + 4*protein_bars + slices_of_pizza <= 65)
m.addConstr(5*apple_pies**2 + 4*cornichons**2 + slices_of_pizza**2 <= 71)
m.addConstr(5*apple_pies + 4*cornichons + 4*protein_bars + slices_of_pizza <= 71)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

