
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Resource_Allocation")

    # Create variables
    ringo = model.addVar(vtype=gp.GRB.INTEGER, name="ringo")
    jean = model.addVar(vtype=gp.GRB.INTEGER, name="jean")
    dale = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dale")


    # Set objective function
    model.setObjective(9.57 * ringo + 1.98 * jean + 9.91 * dale, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6 * ringo + 2 * jean >= 37, "c0")
    model.addConstr(16 * ringo + 16 * dale >= 7, "c1")
    model.addConstr(7 * jean + 16 * dale >= 9, "c2")
    model.addConstr(2 * jean + 8 * dale <= 79, "c3")
    model.addConstr(6 * ringo + 2 * jean <= 117, "c4")
    model.addConstr(6 * ringo + 8 * dale <= 88, "c5")
    model.addConstr(6 * ringo + 2 * jean + 8 * dale <= 88, "c6")
    model.addConstr(7 * jean + 16 * dale <= 26, "c7")
    model.addConstr(16 * ringo + 16 * dale <= 34, "c8")
    model.addConstr(16 * ringo + 7 * jean + 16 * dale <= 34, "c9")



    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Ringo:', ringo.x)
        print('Jean:', jean.x)
        print('Dale:', dale.x)

    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
