
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Jean
    x2 = model.addVar(name="x2")  # hours worked by Dale

    # Define objective function
    model.setObjective(9.57 * x0 + 1.98 * x1 + 9.91 * x2, gurobi.GRB.MAXIMIZE)

    # Define constraints
    model.addConstr(6 * x0 + 2 * x1 + 8 * x2 <= 132)
    model.addConstr(16 * x0 + 7 * x1 + 16 * x2 <= 40)
    model.addConstr(6 * x0 + 2 * x1 >= 37)
    model.addConstr(16 * x0 + 16 * x2 >= 7)
    model.addConstr(7 * x1 + 16 * x2 >= 9)
    model.addConstr(2 * x1 + 8 * x2 <= 79)
    model.addConstr(6 * x0 + 2 * x1 <= 117)
    model.addConstr(6 * x0 + 8 * x2 <= 88)
    model.addConstr(6 * x0 + 2 * x1 + 8 * x2 <= 88)
    model.addConstr(7 * x1 + 16 * x2 <= 26)
    model.addConstr(16 * x0 + 16 * x2 <= 34)
    model.addConstr(16 * x0 + 7 * x1 + 16 * x2 <= 34)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Ringo: {x0.varValue}")
        print(f"Hours worked by Jean: {x1.varValue}")
        print(f"Hours worked by Dale: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
