
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # air defense batteries
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1") # medical platoons
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="x2") # reconnaissance troops


    # Set objective function
    m.setObjective(x0**2 + 5*x0*x2 + 4*x1**2 + 5*x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7.23*x0 + 24.81*x1 + 14.26*x2 >= 147, "c0")
    m.addConstr(24.81*x1 + 14.26*x2 >= 147, "c1")
    m.addConstr(12.68*x0**2 + 11.12*x2**2 >= 90, "c2")
    m.addConstr(12.68*x0 + 22.6*x1 >= 73, "c3")
    m.addConstr(12.68*x0 + 22.6*x1 + 11.12*x2 >= 73, "c4")
    m.addConstr(x0 - 7*x1 >= 0, "c5")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
