
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="air_defense_batteries", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="medical_platoons", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="reconnaissance_troops", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(1 * x1**2 + 5 * x1 * x3 + 4 * x2**2 + 5 * x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(24.81 * x2 + 14.26 * x3 >= 147)
m.addConstr(7.23 * x1 + 24.81 * x2 + 14.26 * x3 >= 147)
m.addConstr(12.68**2 * x1**2 + 11.12**2 * x3**2 >= 90)
m.addConstr(12.68 * x1 + 22.6 * x2 >= 73)
m.addConstr(12.68 * x1 + 22.6 * x2 + 11.12 * x3 >= 73)
m.addConstr(x1 - 7 * x2 >= 0)

# Update model
m.update()

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Air defense batteries: ", x1.varValue)
    print("Medical platoons: ", x2.varValue)
    print("Reconnaissance troops: ", x3.varValue)
else:
    print("The model is infeasible")
