
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")


# Set objective function
m.setObjective(5.81 * vitamin_b3 + 1.67 * iron + 7.59 * vitamin_d + 7.7 * calcium, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(16 * vitamin_b3 + 9 * vitamin_d >= 50)
m.addConstr(16 * vitamin_b3 + 18 * calcium >= 49)
m.addConstr(16 * vitamin_b3 + 34 * iron >= 72)
m.addConstr(34 * iron + 9 * vitamin_d >= 128)
m.addConstr(16 * vitamin_b3 + 9 * vitamin_d + 18 * calcium >= 109)
m.addConstr(34 * iron + 9 * vitamin_d + 18 * calcium >= 109)
m.addConstr(16 * vitamin_b3 + 9 * vitamin_d + 18 * calcium >= 79)
m.addConstr(34 * iron + 9 * vitamin_d + 18 * calcium >= 79)
m.addConstr(33 * vitamin_b3 + 20 * iron + 30 * calcium >= 56)
m.addConstr(33 * vitamin_b3 + 20 * iron + 34 * vitamin_d >= 56)
m.addConstr(20 * iron + 34 * vitamin_d + 30 * calcium >= 56)
m.addConstr(33 * vitamin_b3 + 20 * iron + 30 * calcium >= 50)
m.addConstr(33 * vitamin_b3 + 20 * iron + 34 * vitamin_d >= 50)
m.addConstr(20 * iron + 34 * vitamin_d + 30 * calcium >= 50)
m.addConstr(33 * vitamin_b3 + 20 * iron + 30 * calcium >= 42)
m.addConstr(33 * vitamin_b3 + 20 * iron + 34 * vitamin_d >= 42)
m.addConstr(20 * iron + 34 * vitamin_d + 30 * calcium >= 42)
m.addConstr(27 * vitamin_b3 + 34 * vitamin_d >= 20)
m.addConstr(27 * vitamin_b3 + 7 * iron >= 39)
m.addConstr(34 * vitamin_d + 4 * calcium >= 15)
m.addConstr(7 * iron + 4 * calcium >= 42)
m.addConstr(27 * vitamin_b3 + 34 * vitamin_d + 4 * calcium >= 43)
m.addConstr(16 * vitamin_b3 + 18 * calcium <= 179)
m.addConstr(16 * vitamin_b3 + 34 * iron <= 340)
m.addConstr(16 * vitamin_b3 + 9 * vitamin_d <= 483)
m.addConstr(34 * iron + 18 * calcium <= 479)
m.addConstr(9 * vitamin_d + 18 * calcium <= 491)
m.addConstr(16 * vitamin_b3 + 34 * iron + 9 * vitamin_d <= 241)
m.addConstr(16 * vitamin_b3 + 9 * vitamin_d + 18 * calcium <= 295)
m.addConstr(16 * vitamin_b3 + 34 * iron + 18 * calcium <= 292)
m.addConstr(16 * vitamin_b3 + 34 * iron + 9 * vitamin_d + 18 * calcium <= 292)
m.addConstr(20 * iron + 34 * vitamin_d <= 154)
m.addConstr(34 * vitamin_d + 30 * calcium <= 265)
m.addConstr(33 * vitamin_b3 + 30 * calcium <= 159)
m.addConstr(33 * vitamin_b3 + 34 * vitamin_d <= 209)
m.addConstr(33 * vitamin_b3 + 20 * iron + 34 * vitamin_d + 30 * calcium <= 209)
m.addConstr(7 * iron + 34 * vitamin_d <= 88)
m.addConstr(27 * vitamin_b3 + 7 * iron <= 65)
m.addConstr(27 * vitamin_b3 + 34 * vitamin_d <= 73)
m.addConstr(34 * vitamin_d + 4 * calcium <= 95)
m.addConstr(27 * vitamin_b3 + 7 * iron + 34 * vitamin_d + 4 * calcium <= 95)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

