
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
potatoes = m.addVar(lb=0, name="potatoes")
lemons = m.addVar(lb=0, name="lemons")
protein_bars = m.addVar(lb=0, name="protein_bars")
pickles = m.addVar(lb=0, name="pickles")

# Set objective function
m.setObjective(4*potatoes + 5*lemons + 6*protein_bars + 6*pickles, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(12*potatoes + 12*pickles >= 23)
m.addConstr(12*potatoes + 13*protein_bars >= 8)
m.addConstr(12*potatoes + 13*protein_bars + 12*pickles >= 16)
m.addConstr(11*lemons + 13*protein_bars + 12*pickles >= 16)
m.addConstr(12*potatoes + 11*lemons + 12*pickles >= 16)
m.addConstr(12*potatoes + 11*lemons + 13*protein_bars >= 16)
m.addConstr(12*potatoes + 13*protein_bars + 12*pickles >= 20)
m.addConstr(11*lemons + 13*protein_bars + 12*pickles >= 20)
m.addConstr(12*potatoes + 11*lemons + 12*pickles >= 20)
m.addConstr(12*potatoes + 11*lemons + 13*protein_bars >= 20)
m.addConstr(12*potatoes + 13*protein_bars + 12*pickles >= 19)
m.addConstr(11*lemons + 13*protein_bars + 12*pickles >= 19)
m.addConstr(12*potatoes + 11*lemons + 12*pickles >= 19)
m.addConstr(12*potatoes + 11*lemons + 13*protein_bars >= 19)
m.addConstr(12*potatoes + 13*protein_bars + 12*pickles >= 22)
m.addConstr(11*lemons + 13*protein_bars + 12*pickles >= 22)
m.addConstr(12*potatoes + 11*lemons + 12*pickles >= 22)
m.addConstr(12*potatoes + 11*lemons + 13*protein_bars >= 22)
m.addConstr(12*potatoes + 11*lemons + 13*protein_bars + 12*pickles >= 22)
m.addConstr(11*potatoes + 9*pickles >= 14)
m.addConstr(9*protein_bars + 9*pickles >= 32)
m.addConstr(11*potatoes + 9*protein_bars >= 33)
m.addConstr(2*lemons + 9*pickles >= 17)
m.addConstr(11*potatoes + 2*lemons + 9*protein_bars >= 35)
m.addConstr(11*potatoes + 2*lemons + 9*protein_bars + 9*pickles >= 35)
m.addConstr(13*potatoes + 2*lemons >= 11)
m.addConstr(13*potatoes + 11*protein_bars >= 20)
m.addConstr(13*potatoes + 6*pickles >= 11)
m.addConstr(13*potatoes + 2*lemons + 11*protein_bars >= 20)
m.addConstr(13*potatoes + 2*lemons + 6*pickles >= 20)
m.addConstr(13*potatoes + 2*lemons + 11*protein_bars >= 18)
m.addConstr(13*potatoes + 2*lemons + 6*pickles >= 18)
m.addConstr(13*potatoes + 2*lemons + 11*protein_bars + 6*pickles >= 18)
m.addConstr(7*lemons - 5*pickles >= 0)
m.addConstr(10*potatoes - 5*lemons >= 0)
m.addConstr(12*potatoes + 11*lemons + 12*pickles <= 70)
m.addConstr(11*potatoes + 9*protein_bars <= 78)
m.addConstr(9*protein_bars + 9*pickles <= 70)
m.addConstr(2*lemons + 9*protein_bars <= 127)
m.addConstr(11*potatoes + 2*lemons <= 50)
m.addConstr(11*potatoes + 9*protein_bars + 9*pickles <= 151)
m.addConstr(2*lemons + 9*protein_bars + 9*pickles <= 88)
m.addConstr(11*potatoes + 2*lemons + 9*pickles <= 90)
m.addConstr(13*potatoes + 6*pickles <= 25)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

