
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["bagged salads", "apples", "hamburgers", "sashimi", "bowls of instant ramen"])


# Set objective function
m.setObjective(6*x[0] + 4*x[1] + 8*x[2] + 8*x[3] + 8*x[4], gp.GRB.MINIMIZE)

# Add constraints

protein = [10, 16, 25, 17, 18]
calcium = [4, 14, 12, 18, 22]

m.addConstr(16*x[1] + 18*x[4] >= 46)
m.addConstr(10*x[0] + 18*x[4] >= 77)
m.addConstr(10*x[0] + 16*x[1] >= 76)
m.addConstr(10*x[0] + 17*x[3] >= 79)
m.addConstr(16*x[1] + 25*x[2] >= 65)
m.addConstr(16*x[1] + 17*x[3] >= 44)
m.addConstr(10*x[0] + 16*x[1] + 25*x[2] + 17*x[3] + 18*x[4] >= 44)


m.addConstr(12*x[2] + 18*x[3] >= 58)
m.addConstr(14*x[1] + 22*x[4] >= 88)
m.addConstr(4*x[0] + 12*x[2] >= 39)
m.addConstr(14*x[1] + 12*x[2] >= 80)
m.addConstr(4*x[0] + 14*x[1] >= 91)
m.addConstr(14*x[1] + 12*x[2] + 22*x[4] >= 50)
m.addConstr(4*x[0] + 12*x[2] + 18*x[3] >= 50)
m.addConstr(14*x[1] + 12*x[2] + 22*x[4] >= 74)
m.addConstr(4*x[0] + 12*x[2] + 18*x[3] >= 74)
m.addConstr(4*x[0] + 14*x[1] + 12*x[2] + 18*x[3] + 22*x[4] >= 74)

m.addConstr(3*x[0] - 3*x[3] >= 0)
m.addConstr(6*x[0] - 6*x[2] >= 0)


m.addConstr(10*x[0] + 25*x[2] <= 311)
m.addConstr(10*x[0] + 16*x[1] + 18*x[4] <= 371)
m.addConstr(16*x[1] + 25*x[2] + 18*x[4] <= 277)
m.addConstr(10*x[0] + 16*x[1] + 17*x[3] <= 392)
m.addConstr(25*x[2] + 17*x[3] + 18*x[4] <= 196)
m.addConstr(10*x[0] + 17*x[3] + 18*x[4] <= 306)
m.addConstr(10*x[0] + 25*x[2] + 18*x[4] <= 245)
m.addConstr(16*x[1] + 17*x[3] + 18*x[4] <= 384)
m.addConstr(10*x[0] + 16*x[1] + 25*x[2] <= 389)
m.addConstr(10*x[0] + 25*x[2] + 17*x[3] <= 334)

m.addConstr(14*x[1] + 22*x[4] <= 376)
m.addConstr(4*x[0] + 14*x[1] <= 377)
m.addConstr(12*x[2] + 22*x[4] <= 398)
m.addConstr(4*x[0] + 12*x[2] <= 130)
m.addConstr(4*x[0] + 14*x[1] + 12*x[2] <= 136)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

