
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # bagged salads
x1 = m.addVar(name="x1", lb=0)  # apples
x2 = m.addVar(name="x2", lb=0)  # hamburgers
x3 = m.addVar(name="x3", lb=0)  # sashimi
x4 = m.addVar(name="x4", lb=0)  # bowls of instant ramen

# Objective function
m.setObjective(6 * x0 + 4 * x1 + 8 * x2 + 8 * x3 + 8 * x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(10 * x0 + 16 * x1 + 25 * x2 + 17 * x3 + 18 * x4 <= 411)
m.addConstr(4 * x0 + 14 * x1 + 12 * x2 + 18 * x3 + 22 * x4 <= 461)
m.addConstr(16 * x1 + 18 * x4 >= 46)
m.addConstr(10 * x0 + 18 * x4 >= 77)
m.addConstr(10 * x0 + 16 * x1 >= 76)
m.addConstr(10 * x0 + 17 * x3 >= 79)
m.addConstr(16 * x1 + 25 * x2 >= 65)
m.addConstr(16 * x1 + 17 * x3 >= 44)
m.addConstr(10 * x0 + 16 * x1 + 25 * x2 + 17 * x3 + 18 * x4 >= 44)
m.addConstr(12 * x2 + 18 * x3 >= 58)
m.addConstr(14 * x1 + 22 * x4 >= 88)
m.addConstr(4 * x0 + 12 * x2 >= 39)
m.addConstr(14 * x1 + 12 * x2 >= 80)
m.addConstr(4 * x0 + 14 * x1 >= 91)
m.addConstr(14 * x1 + 12 * x2 + 22 * x4 >= 50)
m.addConstr(4 * x0 + 12 * x2 + 18 * x3 >= 50)
m.addConstr(14 * x1 + 12 * x2 + 22 * x4 >= 74)
m.addConstr(4 * x0 + 12 * x2 + 18 * x3 >= 74)
m.addConstr(4 * x0 + 14 * x1 + 12 * x2 + 18 * x3 + 22 * x4 >= 74)
m.addConstr(3 * x0 - 3 * x3 >= 0)
m.addConstr(6 * x0 - 6 * x2 >= 0)
m.addConstr(10 * x0 + 25 * x2 <= 311)
m.addConstr(10 * x0 + 16 * x1 + 18 * x4 <= 371)
m.addConstr(16 * x1 + 25 * x2 + 18 * x4 <= 277)
m.addConstr(10 * x0 + 16 * x1 + 17 * x3 <= 392)
m.addConstr(25 * x2 + 17 * x3 + 18 * x4 <= 196)
m.addConstr(10 * x0 + 17 * x3 + 18 * x4 <= 306)
m.addConstr(10 * x0 + 25 * x2 + 18 * x4 <= 245)
m.addConstr(16 * x1 + 17 * x3 + 18 * x4 <= 384)
m.addConstr(10 * x0 + 16 * x1 + 25 * x2 <= 389)
m.addConstr(10 * x0 + 25 * x2 + 17 * x3 <= 334)
m.addConstr(14 * x1 + 22 * x4 <= 376)
m.addConstr(4 * x0 + 14 * x1 <= 377)
m.addConstr(12 * x2 + 22 * x4 <= 398)
m.addConstr(4 * x0 + 12 * x2 <= 130)
m.addConstr(4 * x0 + 14 * x1 + 12 * x2 <= 136)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("The model is infeasible")
