
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="paper_towel_rolls")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="dish_soap_bottles")


    # Set objective function
    m.setObjective(1*x0 + 9*x1 + 4*x2 + 6*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14*x1 + 7*x3 >= 39)
    m.addConstr(9*x0 + 5*x2 >= 19)
    m.addConstr(9*x0 + 14*x1 + 5*x2 + 7*x3 >= 19)
    m.addConstr(13*x0 + 3*x3 >= 55)
    m.addConstr(13*x0 + 8*x2 >= 44)
    m.addConstr(11*x1 + 8*x2 >= 61)
    m.addConstr(11*x1 + 3*x3 >= 40)
    m.addConstr(11*x1 + 8*x2 + 3*x3 >= 51)
    m.addConstr(13*x0 + 11*x1 + 8*x2 >= 51)
    m.addConstr(11*x1 + 8*x2 + 3*x3 >= 38)
    m.addConstr(13*x0 + 11*x1 + 8*x2 >= 38)
    m.addConstr(13*x0 + 11*x1 + 8*x2 + 3*x3 >= 38)
    m.addConstr(5*x1 - 9*x2 >= 0)
    m.addConstr(9*x0 + 7*x3 <= 161)
    m.addConstr(9*x0 + 5*x2 <= 155)
    m.addConstr(9*x0 + 14*x1 + 5*x2 <= 51)
    m.addConstr(11*x1 + 8*x2 <= 255)
    m.addConstr(13*x0 + 11*x1 <= 223)
    m.addConstr(11*x1 + 3*x3 <= 250)
    m.addConstr(13*x0 + 8*x2 <= 277)
    m.addConstr(13*x0 + 3*x3 <= 209)
    m.addConstr(8*x2 + 3*x3 <= 171)
    m.addConstr(11*x1 + 8*x2 + 3*x3 <= 174)
    m.addConstr(13*x0 + 11*x1 + 8*x2 <= 76)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
