
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="paper_towel_rolls", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="diapers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="lightbulbs", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="dish_soap_bottles", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(1*x0 + 9*x1 + 4*x2 + 6*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(14*x1 + 7*x3 >= 39)
    model.addConstr(9*x0 + 5*x2 >= 19)
    model.addConstr(9*x0 + 14*x1 + 5*x2 + 7*x3 >= 19)
    model.addConstr(13*x0 + 3*x3 >= 55)
    model.addConstr(13*x0 + 8*x2 >= 44)
    model.addConstr(11*x1 + 8*x2 >= 61)
    model.addConstr(11*x1 + 3*x3 >= 40)
    model.addConstr(11*x1 + 8*x2 + 3*x3 >= 51)
    model.addConstr(13*x0 + 11*x1 + 8*x2 >= 51)
    model.addConstr(11*x1 + 8*x2 + 3*x3 >= 38)
    model.addConstr(13*x0 + 11*x1 + 8*x2 >= 38)
    model.addConstr(13*x0 + 11*x1 + 8*x2 + 3*x3 >= 38)
    model.addConstr(5*x1 - 9*x2 >= 0)
    model.addConstr(9*x0 + 7*x3 <= 161)
    model.addConstr(9*x0 + 5*x2 <= 155)
    model.addConstr(9*x0 + 14*x1 + 5*x2 <= 51)
    model.addConstr(11*x1 + 8*x2 <= 255)
    model.addConstr(13*x0 + 11*x1 <= 223)
    model.addConstr(11*x1 + 3*x3 <= 250)
    model.addConstr(13*x0 + 8*x2 <= 277)
    model.addConstr(13*x0 + 3*x3 <= 209)
    model.addConstr(8*x2 + 3*x3 <= 171)
    model.addConstr(11*x1 + 8*x2 + 3*x3 <= 174)
    model.addConstr(13*x0 + 11*x1 + 8*x2 <= 76)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Paper towel rolls: ", x0.varValue)
        print("Diapers: ", x1.varValue)
        print("Lightbulbs: ", x2.varValue)
        print("Dish soap bottles: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
