
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables (apple pies can be non-integer, cantaloupes must be integer)
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="apple_pies")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="cantaloupes")

# Objective function: Maximize 1.42*x1 + 8.78*x2
m.setObjective(1.42*x1 + 8.78*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(3.47*x1 + 0.49*x2 >= 19, name="calcium_min")
m.addConstr(4.7*x1 + 3.14*x2 >= 23, name="iron_min")
m.addConstr(5.64*x1 + 1.53*x2 >= 7, name="protein_min")
m.addConstr(3*x1 - 9*x2 >= 0, name="combination_constraint")
m.addConstr(3.47*x1 + 0.49*x2 <= 30, name="calcium_max")
m.addConstr(4.7*x1 + 3.14*x2 <= 28, name="iron_max")
m.addConstr(5.64*x1 + 1.53*x2 <= 26, name="protein_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Apple Pies: {x1.x}")
    print(f"Cantaloupes: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
