
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="apple_pies", lb=0)  # You can use a non-integer number of apple pies
    x2 = model.addVar(name="cantaloupes", lb=0, integrality=1)  # You're limited to a nonfractional number of cantaloupes

    # Define the objective function
    model.setObjective(1.42 * x1 + 8.78 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(3.47 * x1 + 0.49 * x2 >= 19)  
    model.addConstr(4.7 * x1 + 3.14 * x2 >= 23)  
    model.addConstr(5.64 * x1 + 1.53 * x2 >= 7)  
    model.addConstr(3 * x1 - 9 * x2 >= 0)  
    model.addConstr(3.47 * x1 + 0.49 * x2 <= 30)  
    model.addConstr(4.7 * x1 + 3.14 * x2 <= 28)  
    model.addConstr(5.64 * x1 + 1.53 * x2 <= 26)  

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Apple pies: ", x1.varValue)
        print("Cantaloupes: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
