
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by John
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Bobby
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by Peggy
    x3 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x3")  # hours worked by Bill


    # Set objective function
    model.setObjective(5.01*x0 + 5.97*x1 + 8.09*x2 + 5.78*x3, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7*x1 + 5*x2 >= 5, "c0")
    model.addConstr(5*x2 + 1*x3 >= 7, "c1")
    model.addConstr(5*x0 + 5*x2 >= 10, "c2")
    model.addConstr(5*x0 + 7*x1 + 5*x2 + 1*x3 >= 10, "c3")
    model.addConstr(x0 - x1 >= 0, "c4")
    model.addConstr(9*x2 - 10*x3 >= 0, "c5")
    model.addConstr(5*x2 + 1*x3 <= 41, "c6")
    model.addConstr(7*x1 + 5*x2 <= 29, "c7")
    model.addConstr(5*x0 + 7*x1 + 5*x2 <= 28, "c8")
    model.addConstr(5*x0 + 7*x1 + 1*x3 <= 16, "c9")
    model.addConstr(7*x1 + 5*x2 + 1*x3 <= 30, "c10")

    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
