
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # hours worked by John
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Bobby
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Peggy
    x4 = model.addVar(name="x4", lb=0)  # hours worked by Bill

    # Define the objective function
    model.setObjective(5.01 * x1 + 5.97 * x2 + 8.09 * x3 + 5.78 * x4, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(7 * x2 + 5 * x3 >= 5)
    model.addConstr(5 * x3 + x4 >= 7)
    model.addConstr(5 * x1 + 5 * x3 >= 10)
    model.addConstr(5 * x1 + 7 * x2 + 5 * x3 + x4 >= 10)
    model.addConstr(x1 - x2 >= 0)
    model.addConstr(9 * x3 - 10 * x4 >= 0)
    model.addConstr(5 * x3 + x4 <= 41)
    model.addConstr(7 * x2 + 5 * x3 <= 29)
    model.addConstr(5 * x1 + 7 * x2 + 5 * x3 <= 28)
    model.addConstr(5 * x1 + 7 * x2 + x4 <= 16)
    model.addConstr(7 * x2 + 5 * x3 + x4 <= 30)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
