
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
ravioli = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ravioli")
cornichons = m.addVar(vtype=gp.GRB.INTEGER, name="cornichons")


# Set objective function
m.setObjective(1.89 * ravioli + 6.47 * cornichons, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * ravioli + 3 * cornichons >= 8, "healthiness_min")
m.addConstr(1 * ravioli + 7 * cornichons >= 13, "calcium_min")
m.addConstr(7 * ravioli + 4 * cornichons >= 23, "carbohydrates_min")
m.addConstr(1 * ravioli - 2 * cornichons >= 0, "ravioli_cornichons_ratio")
m.addConstr(7 * ravioli + 3 * cornichons <= 24, "healthiness_max")
m.addConstr(1 * ravioli + 7 * cornichons <= 32, "calcium_max")
m.addConstr(7 * ravioli + 4 * cornichons <= 46, "carbohydrates_max")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ravioli:', ravioli.x)
    print('cornichons:', cornichons.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

