
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="ravioli")
x2 = m.addVar(vtype=GRB.INTEGER, name="cornichons")

# Set objective function
m.setObjective(1.89*x1 + 6.47*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(7*x1 + 3*x2 >= 8, "healthiness_rating")
m.addConstr(x1 + 7*x2 >= 13, "calcium_constraint")
m.addConstr(7*x1 + 4*x2 >= 23, "carbohydrates_constraint")
m.addConstr(x1 - 2*x2 >= 0, "linear_constraint")
m.addConstr(7*x1 + 3*x2 <= 24, "max_healthiness_rating")
m.addConstr(x1 + 7*x2 <= 32, "max_calcium")
m.addConstr(7*x1 + 4*x2 <= 46, "max_carbohydrates")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Ravioli: {x1.x}")
    print(f"Cornichons: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
