
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="ravioli", lb=0)  # ravioli can be any non-negative real number
x2 = model.addVar(name="cornichons", lb=0, type=gurobi.GRB.INTEGER)  # cornichons must be a non-negative integer

# Set the objective function
model.setObjective(1.89 * x1 + 6.47 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * x1 + 3 * x2 >= 8, name="healthiness_rating_min")
model.addConstr(x1 + 7 * x2 >= 13, name="calcium_min")
model.addConstr(7 * x1 + 4 * x2 >= 23, name="carbohydrates_min")
model.addConstr(x1 - 2 * x2 >= 0, name="ravioli_cornichons_relationship")
model.addConstr(7 * x1 + 3 * x2 <= 24, name="healthiness_rating_max")
model.addConstr(x1 + 7 * x2 <= 32, name="calcium_max")
model.addConstr(7 * x1 + 4 * x2 <= 46, name="carbohydrates_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ravioli: {x1.varValue}")
    print(f"Cornichons: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
