
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
paul = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="paul")
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")  # Corrected to CONTINUOUS
bill = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bill")
dale = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="dale")
ringo = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ringo")
bobby = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bobby")


# Set objective function
m.setObjective(5*john + 2*paul + 3*hank + 5*bill + 7*dale + 8*ringo + 2*bobby, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * bill + 14 * dale >= 56)
m.addConstr(7 * paul + 14 * bill + 14 * dale >= 73)
m.addConstr(7 * paul + 14 * bill + 4 * bobby >= 73)
m.addConstr(9 * john + 7 * hank + 14 * dale >= 73)
m.addConstr(7 * paul + 14 * bill + 14 * dale >= 59)
m.addConstr(7 * paul + 14 * bill + 4 * bobby >= 59)
m.addConstr(9 * john + 7 * hank + 14 * dale >= 59)
m.addConstr(7 * paul + 14 * bill + 14 * dale >= 63)
m.addConstr(7 * paul + 14 * bill + 4 * bobby >= 63)
m.addConstr(9 * john + 7 * hank + 14 * dale >= 63)
m.addConstr(7 * john + 1 * dale >= 42)
m.addConstr(3 * hank + 12 * bobby >= 45)
m.addConstr(15 * bill + 12 * bobby >= 37)
m.addConstr(3 * hank + 15 * bill >= 24)
m.addConstr(5 * john - bobby >= 0)

# Likelihood to quit index constraints
m.addConstr(9*john + 7*hank <= 359)
m.addConstr(14*dale + 8*ringo <= 183)
m.addConstr(14*bill + 8*ringo <= 147)
# ... (rest of the likelihood to quit index constraints)

# Organization score constraints
m.addConstr(3*hank + 12*bobby <= 109)
m.addConstr(18*paul + 3*hank <= 101)
m.addConstr(7*john + 10*ringo <= 207)
# ... (rest of the organization score constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

