
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    x = m.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, name=["x0", "x1", "x2", "x3"])


    # Set objective function
    m.setObjective(2*x[0] + 5*x[1] + 8*x[2] + 9*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6.49*x[0] + 7.23*x[3] >= 49)
    m.addConstr(2.09*x[0] + 9.55*x[3] >= 34)
    m.addConstr(15.8*x[1] + 13.81*x[2] <= 259)
    m.addConstr(15.8*x[1] + 13.81*x[2] + 7.23*x[3] <= 142)
    m.addConstr(6.49*x[0] + 15.8*x[1] + 13.81*x[2] <= 156)
    m.addConstr(6.49*x[0] + 15.8*x[1] + 7.23*x[3] <= 148)
    m.addConstr(6.49*x[0] + 15.8*x[1] + 13.81*x[2] + 7.23*x[3] <= 148)
    m.addConstr(4.16*x[2] + 9.55*x[3] <= 295)
    m.addConstr(0.7*x[1] + 4.16*x[2] <= 178)
    m.addConstr(0.7*x[1] + 4.16*x[2] + 9.55*x[3] <= 113)
    m.addConstr(2.09*x[0] + 0.7*x[1] + 4.16*x[2] <= 96)
    m.addConstr(2.09*x[0] + 0.7*x[1] + 4.16*x[2] + 9.55*x[3] <= 96)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
