
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(name="milligrams_of_vitamin_B4")
x1 = m.addVar(name="milligrams_of_potassium")
x2 = m.addVar(name="milligrams_of_vitamin_B1")
x3 = m.addVar(name="milligrams_of_vitamin_B6")

# Define the objective function
m.setObjective(2*x0 + 5*x1 + 8*x2 + 9*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6.49*x0 + 15.8*x1 + 13.81*x2 <= 156)
m.addConstr(6.49*x0 + 15.8*x1 + 7.23*x3 <= 148)
m.addConstr(15.8*x1 + 13.81*x2 + 7.23*x3 <= 142)
m.addConstr(0.7*x1 + 4.16*x2 <= 178)
m.addConstr(2.09*x0 + 0.7*x1 + 4.16*x2 <= 96)
m.addConstr(6.49*x0 + 7.23*x3 >= 49)
m.addConstr(2.09*x0 + 9.55*x3 >= 34)
m.addConstr(15.8*x1 + 13.81*x2 <= 259)

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B4: {x0.x}")
    print(f"Milligrams of potassium: {x1.x}")
    print(f"Milligrams of vitamin B1: {x2.x}")
    print(f"Milligrams of vitamin B6: {x3.x}")
else:
    print("No optimal solution found.")
