
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # milligrams of vitamin B4
x1 = m.addVar(name="x1", lb=0)  # milligrams of potassium
x2 = m.addVar(name="x2", lb=0)  # milligrams of vitamin B1
x3 = m.addVar(name="x3", lb=0)  # milligrams of vitamin B6

# Define the objective function
m.setObjective(2*x0 + 5*x1 + 8*x2 + 9*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6.49*x0 <= 288)
m.addConstr(2.09*x0 <= 351)
m.addConstr(15.8*x1 <= 288)
m.addConstr(0.7*x1 <= 351)
m.addConstr(13.81*x2 <= 288)
m.addConstr(4.16*x2 <= 351)
m.addConstr(7.23*x3 <= 288)
m.addConstr(9.55*x3 <= 351)
m.addConstr(6.49*x0 + 7.23*x3 >= 49)
m.addConstr(2.09*x0 + 9.55*x3 >= 34)
m.addConstr(15.8*x1 + 13.81*x2 <= 259)
m.addConstr(15.8*x1 + 13.81*x2 + 7.23*x3 <= 142)
m.addConstr(6.49*x0 + 15.8*x1 + 13.81*x2 <= 156)
m.addConstr(6.49*x0 + 15.8*x1 + 7.23*x3 <= 148)
m.addConstr(6.49*x0 + 15.8*x1 + 13.81*x2 + 7.23*x3 <= 148)
m.addConstr(4.16*x2 + 9.55*x3 <= 295)
m.addConstr(0.7*x1 + 4.16*x2 <= 178)
m.addConstr(0.7*x1 + 4.16*x2 + 9.55*x3 <= 113)
m.addConstr(2.09*x0 + 0.7*x1 + 4.16*x2 <= 96)
m.addConstr(2.09*x0 + 0.7*x1 + 4.16*x2 + 9.55*x3 <= 96)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B4: {x0.varValue}")
    print(f"Milligrams of potassium: {x1.varValue}")
    print(f"Milligrams of vitamin B1: {x2.varValue}")
    print(f"Milligrams of vitamin B6: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
