
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("vitamin_optimization")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_K")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_D")


    # Set objective function
    model.setObjective(3*x0 + 6*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7*x0 + 11*x1 >= 17, "kidney_support_min")
    model.addConstr(1*x0 + 9*x1 >= 27, "energy_stability_min")
    model.addConstr(5*x0 + 5*x1 >= 22, "immune_support_min")
    model.addConstr(-10*x0 + 3*x1 >= 0, "vitamin_ratio")
    model.addConstr(7*x0 + 11*x1 <= 54, "kidney_support_max")
    model.addConstr(1*x0 + 9*x1 <= 83, "energy_stability_max")
    model.addConstr(5*x0 + 5*x1 <= 28, "immune_support_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Milligrams of Vitamin K: {x0.x}")
        print(f"Milligrams of Vitamin D: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
