
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_K")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_D")

# Set the objective function
m.setObjective(3*x0 + 6*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x0 + 11*x1 >= 17, "kidney_support_index_lower_bound")
m.addConstr(1*x0 + 9*x1 >= 27, "energy_stability_index_lower_bound")
m.addConstr(5*x0 + 5*x1 >= 22, "immune_support_index_lower_bound")
m.addConstr(-10*x0 + 3*x1 >= 0, "additional_constraint")
m.addConstr(7*x0 + 11*x1 <= 54, "kidney_support_index_upper_bound")
m.addConstr(1*x0 + 9*x1 <= 83, "energy_stability_index_upper_bound")
m.addConstr(5*x0 + 5*x1 <= 28, "immune_support_index_upper_bound")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin K: {x0.x}")
    print(f"Milligrams of Vitamin D: {x1.x}")
else:
    print("No optimal solution found")
