
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_vitamin_K", lb=0)  # Assuming non-negative
    x2 = model.addVar(name="milligrams_of_vitamin_D", lb=0)  # Assuming non-negative

    # Define the objective function
    model.setObjective(3*x1 + 6*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7*x1 + 11*x2 >= 17, name="kidney_support_index_min")
    model.addConstr(1*x1 + 9*x2 >= 27, name="energy_stability_index_min")
    model.addConstr(5*x1 + 5*x2 >= 22, name="immune_support_index_min")
    model.addConstr(-10*x1 + 3*x2 >= 0, name="vitamin_tradeoff")
    model.addConstr(7*x1 + 11*x2 <= 54, name="kidney_support_index_max")
    model.addConstr(1*x1 + 9*x2 <= 83, name="energy_stability_index_max")
    model.addConstr(5*x1 + 5*x2 <= 28, name="immune_support_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin K: {x1.varValue}")
        print(f"Milligrams of vitamin D: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
