
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
lanyards = m.addVar(vtype=GRB.INTEGER, name="lanyards")
color_printers = m.addVar(vtype=GRB.INTEGER, name="color_printers")

# Set objective function
m.setObjective(3 * lanyards + 3 * color_printers, GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * lanyards + 23 * color_printers >= 61, "usefulness_rating_min")
m.addConstr(23 * lanyards + 9 * color_printers >= 48, "storage_space_min")
m.addConstr(6 * lanyards - 6 * color_printers >= 0, "lanyards_vs_printers")
m.addConstr(4 * lanyards + 23 * color_printers <= 79, "usefulness_rating_max")
m.addConstr(23 * lanyards + 9 * color_printers <= 81, "storage_space_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('lanyards:', lanyards.x)
    print('color_printers:', color_printers.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

