
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x0 = m.addVar(vtype=GRB.INTEGER, name="lanyards")
x1 = m.addVar(vtype=GRB.INTEGER, name="color_printers")

# Set the objective function
m.setObjective(3*x0 + 3*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x0 + 23*x1 >= 61, "usefulness_rating")
m.addConstr(23*x0 + 9*x1 >= 48, "min_storage_space")
m.addConstr(6*x0 - 6*x1 >= 0, "lanyards_color_printers_ratio")
m.addConstr(4*x0 + 23*x1 <= 79, "max_usefulness_rating")
m.addConstr(23*x0 + 9*x1 <= 81, "max_storage_space")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Lanyards: {x0.x}")
    print(f"Color Printers: {x1.x}")
else:
    print("No optimal solution found.")
