
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="lanyards", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="color_printers", vtype=gurobi.GRB.INTEGER)

    # Objective function: minimize 3*lanyards + 3*color_printers
    model.setObjective(3*x1 + 3*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4*x1 + 23*x2 >= 61)
    model.addConstr(23*x1 + 9*x2 >= 48)
    model.addConstr(6*x1 - 6*x2 >= 0)
    model.addConstr(4*x1 + 23*x2 <= 79)
    model.addConstr(23*x1 + 9*x2 <= 81)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Lanyards: {x1.varValue}")
        print(f"Color Printers: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
