
import gurobipy as gp

# Create a new model
m = gp.Model("military_optimization")

# Create variables
x = {}
var_names = ['pathfinder teams', 'reconnaissance troops', 'logistics companies', 'air defense batteries', 'water purification units', 'CBRN platoons', 'military intelligence companies']
obj_coeffs = [6.78, 6.59, 8.41, 3.07, 1.46, 7.72, 9.57]
def_ratings = [3.22, 8.24, 8.63, 0.36, 6.01, 8.75, 1.02]

for i in range(len(var_names)):
    x[i] = m.addVar(vtype=gp.GRB.INTEGER, name=var_names[i])

# Set objective function
m.setObjective(sum(obj_coeffs[i] * x[i] for i in range(len(var_names))), gp.GRB.MAXIMIZE)

# Add constraints
constraints_data = [
    ([0, 2], 13), ([0, 6], 17), ([0, 1, 3], 17), ([1, 4, 5], 17), ([1, 3, 4], 17),
    ([0, 2, 6], 17), ([0, 4, 5], 17), ([0, 1, 4], 17), ([3, 4, 5], 17), ([0, 2, 3], 17),
    ([3, 4, 6], 17), ([2, 3, 6], 17), ([1, 3, 5], 17), ([3, 5, 6], 17), ([0, 3, 4], 17),
    ([2, 5, 6], 17), ([1, 2, 3], 17), ([0, 2, 5], 17), ([0, 1, 5], 17), ([4, 5, 6], 17),
    ([0, 1, 2], 17), ([0,6], 111, "<="), ([0,2], 97, "<="), ([3,6], 115, "<="), ([4,5], 41, "<="),
    ([1,3], 101, "<="), ([3,4], 77, "<="), ([2,6], 137, "<="), ([0,3], 77, "<="), ([5,6], 182, "<="),
    ([1,4], 219, "<="), ([0,1], 62, "<="), ([2,3], 102, "<="), ([2,5], 95, "<="), ([2,3,6], 139, "<="),
    ([3,5,6], 213, "<="), ([1,3,4], 64, "<="), ([1,2,4], 96, "<="), ([0,2,3], 62, "<="), ([1,2,5], 208, "<="),
    ([1,2,3], 120, "<="), ([0,1,4], 101, "<="), ([3,4,5], 59, "<="), ([1,3,6], 201, "<="), ([1,3,5], 183, "<="),
    ([0,2,5], 91, "<="), ([1,4,6], 62, "<="), ([4,5,6], 194, "<="), ([0,3,5], 198, "<="), ([1,5,6], 168, "<="),
    ([0,2,6], 73, "<="), ([0,1,2,3,4,5,6], 73, "<=")
]


for indices, bound, sense in constraints_data:
    if sense == "<=":
        m.addConstr(sum(def_ratings[i] * x[i] for i in indices) <= bound)
    else:  # Default to '>='
        m.addConstr(sum(def_ratings[i] * x[i] for i in indices) >= bound)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status:", m.status)

