
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="x0")  # hours worked by George
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1")  # hours worked by Bill
    x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2")  # hours worked by John


    # Set objective function
    m.setObjective(7.68*x0**2 + 8.67*x0*x1 + 3.79*x1**2 + 6.11*x1*x2 + 6.09*x2**2 + 4.46*x0 + 3.47*x1 + 3.11*x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3.2*x1 + 5.58*x2 >= 26, "c1")
    m.addConstr(1.95*x0 + 3.2*x1 + 5.58*x2 >= 26, "c2")
    m.addConstr(15.65*x0**2 + 10.13*x2**2 >= 33, "c3")
    m.addConstr(15.65*x0 + 1.68*x1 >= 34, "c4")
    m.addConstr(15.65*x0 + 1.68*x1 + 10.13*x2 >= 34, "c5")
    m.addConstr(14.78*x0 + 0.75*x1 >= 33, "c6")
    m.addConstr(0.75*x1 + 5.11*x2 >= 32, "c7")
    m.addConstr(14.78*x0 + 0.75*x1 + 5.11*x2 >= 32, "c8")
    m.addConstr(8.5*x0 + 14.06*x2 >= 25, "c9")
    m.addConstr(10.83*x1 + 14.06*x2 >= 29, "c10")
    m.addConstr(8.5*x0 + 10.83*x1 + 14.06*x2 >= 29, "c11")
    m.addConstr(10*x1 - 7*x2 >= 0, "c12")
    m.addConstr(9*x0 - 9*x1 >= 0, "c13")
    m.addConstr(1.95*x0 + 3.2*x1 <= 36, "c14")
    m.addConstr(1.68*x1 + 10.13*x2 <= 119, "c15")
    m.addConstr(8.5*x0**2 + 10.83*x1**2 <= 71, "c16")
    m.addConstr(8.5*x0 + 10.83*x1 + 14.06*x2 <= 162, "c17")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
