
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by George
    x1 = model.addVar(name="x1")  # hours worked by Bill
    x2 = model.addVar(name="x2")  # hours worked by John

    # Objective function
    model.setObjective(7.68 * x0**2 + 8.67 * x0 * x1 + 3.79 * x1**2 + 6.11 * x1 * x2 + 6.09 * x2**2 + 4.46 * x0 + 3.47 * x1 + 3.11 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1.95 * x0 <= 107)
    model.addConstr(15.65 * x0 <= 166)
    model.addConstr(14.78 * x0 <= 146)
    model.addConstr(8.5 * x0 <= 163)
    model.addConstr(3.2 * x1 <= 107)
    model.addConstr(1.68 * x1 <= 166)
    model.addConstr(0.75 * x1 <= 146)
    model.addConstr(10.83 * x1 <= 163)
    model.addConstr(5.58 * x2 <= 107)
    model.addConstr(10.13 * x2 <= 166)
    model.addConstr(5.11 * x2 <= 146)
    model.addConstr(14.06 * x2 <= 163)
    model.addConstr(3.2 * x1 + 5.58 * x2 >= 26)
    model.addConstr(1.95 * x0 + 3.2 * x1 + 5.58 * x2 >= 26)
    model.addConstr(15.65 * x0**2 + 10.13 * x2**2 >= 33)
    model.addConstr(15.65 * x0 + 1.68 * x1 >= 34)
    model.addConstr(15.65 * x0 + 1.68 * x1 + 10.13 * x2 >= 34)
    model.addConstr(14.78 * x0 + 0.75 * x1 >= 33)
    model.addConstr(0.75 * x1 + 5.11 * x2 >= 32)
    model.addConstr(14.78 * x0 + 0.75 * x1 + 5.11 * x2 >= 32)
    model.addConstr(8.5 * x0 + 14.06 * x2 >= 25)
    model.addConstr(10.83 * x1 + 14.06 * x2 >= 29)
    model.addConstr(8.5 * x0 + 10.83 * x1 + 14.06 * x2 >= 29)
    model.addConstr(10 * x1 - 7 * x2 >= 0)
    model.addConstr(9 * x0 - 9 * x1 >= 0)
    model.addConstr(1.95 * x0 + 3.2 * x1 <= 36)
    model.addConstr(1.68 * x1 + 10.13 * x2 <= 119)
    model.addConstr(8.5 * x0**2 + 10.83 * x1**2 <= 71)
    model.addConstr(8.5 * x0 + 10.83 * x1 + 14.06 * x2 <= 162)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
