
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    lightbulbs = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")
    rubber_gloves = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_gloves")
    paper_towel_rolls = m.addVar(vtype=gp.GRB.INTEGER, name="paper_towel_rolls")

    # Set objective function
    m.setObjective(3 * lightbulbs + 8 * rubber_gloves + 9 * paper_towel_rolls, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4.47 * lightbulbs + 6.34 * rubber_gloves <= 37, "c1")
    m.addConstr(4.47 * lightbulbs + 6.34 * rubber_gloves + 7.49 * paper_towel_rolls <= 51, "c2")
    m.addConstr(0.66 * lightbulbs + 3.04 * rubber_gloves <= 48, "c3")
    m.addConstr(0.66 * lightbulbs + 3.04 * rubber_gloves + 6.28 * paper_towel_rolls <= 74, "c4")
    m.addConstr(6.34 * rubber_gloves + 7.49 * paper_towel_rolls <= 27, "c5")
    m.addConstr(0.66 * lightbulbs + 6.28 * paper_towel_rolls <= 80, "c6")
    m.addConstr(-5 * lightbulbs + 4 * paper_towel_rolls >= 0, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('lightbulbs:', lightbulbs.x)
        print('rubber_gloves:', rubber_gloves.x)
        print('paper_towel_rolls:', paper_towel_rolls.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

