
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
lightbulbs = model.addVar(name='lightbulbs', vtype=gurobi.GRB.INTEGER)
rubber_gloves = model.addVar(name='rubber gloves', vtype=gurobi.GRB.INTEGER)
paper_towel_rolls = model.addVar(name='paper towel rolls', vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(3 * lightbulbs + 8 * rubber_gloves + 9 * paper_towel_rolls, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(-5 * lightbulbs + 4 * paper_towel_rolls >= 0)
model.addConstr(6.34 * rubber_gloves + 7.49 * paper_towel_rolls <= 27)
model.addConstr(4.47 * lightbulbs + 6.34 * rubber_gloves <= 37)
model.addConstr(4.47 * lightbulbs + 6.34 * rubber_gloves + 7.49 * paper_towel_rolls <= 51)
model.addConstr(0.66 * lightbulbs + 6.28 * paper_towel_rolls <= 80)
model.addConstr(0.66 * lightbulbs + 3.04 * rubber_gloves <= 48)
model.addConstr(0.66 * lightbulbs + 3.04 * rubber_gloves + 6.28 * paper_towel_rolls <= 74)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Lightbulbs: ', lightbulbs.varValue)
    print('Rubber Gloves: ', rubber_gloves.varValue)
    print('Paper Towel Rolls: ', paper_towel_rolls.varValue)
else:
    print('The model is infeasible')
