
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="x0") # milligrams of vitamin A
    x1 = m.addVar(vtype=GRB.INTEGER, name="x1") # grams of fat
    x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2") # grams of fiber


    # Set objective function
    m.setObjective(1.97*x0**2 + 1.23*x2**2 + 5.84*x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(14*x0 <= 218, "c0")
    m.addConstr(20*x0 <= 88, "c1")
    m.addConstr(17*x1 <= 218, "c2")
    m.addConstr(8*x1 <= 88, "c3")
    m.addConstr(15*x2 <= 218, "c4")
    m.addConstr(19*x2 <= 88, "c5")
    m.addConstr(14*x0 + 17*x1 >= 54, "c6")
    m.addConstr(14*x0 + 15*x2 >= 26, "c7")
    m.addConstr(14*x0 + 17*x1 + 15*x2 >= 44, "c8")
    m.addConstr(14*x0 + 15*x2 <= 178, "c9")
    m.addConstr(17*x1 + 15*x2 <= 132, "c10")
    m.addConstr(14*x0 + 17*x1 + 15*x2 <= 152, "c11")
    m.addConstr(14*x0 + 17*x1 + 15*x2 <= 152, "c12")
    m.addConstr(20*x0 + 8*x1 <= 78, "c13")
    m.addConstr(8*x1**2 + 19*x2**2 <= 56, "c14")
    m.addConstr(20*x0 + 8*x1 + 19*x2 <= 56, "c15")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
