
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="milligrams of vitamin A", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="grams of fat", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="grams of fiber")

# Set the objective function
m.setObjective(1.97 * x1 ** 2 + 1.23 * x3 ** 2 + 5.84 * x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * x1 <= 218)
m.addConstr(20 * x1 <= 88)
m.addConstr(17 * x2 <= 218)
m.addConstr(8 * x2 <= 88)
m.addConstr(15 * x3 <= 218)
m.addConstr(19 * x3 <= 88)
m.addConstr(14 * x1 + 17 * x2 >= 54)
m.addConstr(14 * x1 + 15 * x3 >= 26)
m.addConstr(14 * x1 + 17 * x2 + 15 * x3 >= 44)
m.addConstr(14 * x1 + 15 * x3 <= 178)
m.addConstr(17 * x2 + 15 * x3 <= 132)
m.addConstr(14 * x1 + 17 * x2 + 15 * x3 <= 152)
m.addConstr(14 * x1 + 8 * x2 <= 78)
m.addConstr(8 * x2 ** 2 + 19 * x3 ** 2 <= 56)
m.addConstr(20 * x1 + 8 * x2 + 19 * x3 <= 56)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of vitamin A: ", x1.varValue)
    print("Grams of fat: ", x2.varValue)
    print("Grams of fiber: ", x3.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
