
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="headsets", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="rubber_bands", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="planners", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="hole_punches", vtype=gurobi.GRB.INTEGER)

    # Define objective function
    model.setObjective(2*x0 + 3*x1 + 5*x2 + 7*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.5*x0 + 2.54*x1 + 0.12*x2 + 2.75*x3 <= 222)
    model.addConstr(1.49*x0 + 0.16*x1 + 0.33*x2 + 2.73*x3 <= 231)
    model.addConstr(0.5*x0 + 0.12*x2 + 2.75*x3 >= 45)
    model.addConstr(0.5*x0 + 2.54*x1 + 0.12*x2 >= 45)
    model.addConstr(0.5*x0 + 0.12*x2 + 2.75*x3 >= 36)
    model.addConstr(0.5*x0 + 2.54*x1 + 0.12*x2 >= 36)
    model.addConstr(1.49*x0 + 0.16*x1 >= 39)
    model.addConstr(0.16*x1 + 0.33*x2 >= 54)
    model.addConstr(0.5*x0 + 2.54*x1 <= 164)
    model.addConstr(2.54*x1 + 0.12*x2 <= 104)
    model.addConstr(0.5*x0 + 0.12*x2 <= 101)
    model.addConstr(2.54*x1 + 2.75*x3 <= 92)
    model.addConstr(0.5*x0 + 2.54*x1 + 0.12*x2 + 2.75*x3 <= 92)
    model.addConstr(0.16*x1 + 0.33*x2 <= 177)
    model.addConstr(1.49*x0 + 0.33*x2 <= 190)
    model.addConstr(0.33*x2 + 2.73*x3 <= 85)
    model.addConstr(1.49*x0 + 0.16*x1 + 0.33*x2 + 2.73*x3 <= 85)
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)
    model.addConstr(x3 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Headsets: {x0.varValue}")
        print(f"Rubber bands: {x1.varValue}")
        print(f"Planners: {x2.varValue}")
        print(f"Hole punches: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
