
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    milkshakes = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milkshakes")
    oranges = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="oranges")
    slices_of_pizza = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="slices of pizza")
    chicken_drumsticks = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="chicken drumsticks")

    # Define the objective function
    model.setObjective(6.35*milkshakes + 7.44*oranges + 2.49*slices_of_pizza + 7.43*chicken_drumsticks, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4*milkshakes + oranges + 5*slices_of_pizza + 5*chicken_drumsticks <= 90)
    model.addConstr(3*milkshakes + 5*oranges + 3*slices_of_pizza + 4*chicken_drumsticks <= 79)
    model.addConstr(2*milkshakes + oranges + 2*slices_of_pizza + 5*chicken_drumsticks <= 70)
    model.addConstr(4*milkshakes + 5*slices_of_pizza >= 8)
    model.addConstr(oranges + 5*slices_of_pizza >= 10)
    model.addConstr(5*slices_of_pizza + 5*chicken_drumsticks >= 20)
    model.addConstr(4*milkshakes + 5*slices_of_pizza + 5*chicken_drumsticks >= 14)
    model.addConstr(oranges + 5*chicken_drumsticks >= 15)
    model.addConstr(2*milkshakes + 2*slices_of_pizza >= 6)
    model.addConstr(2*slices_of_pizza + 5*chicken_drumsticks >= 5)
    model.addConstr(oranges + 2*slices_of_pizza >= 8)
    model.addConstr(2*milkshakes + oranges >= 12)
    model.addConstr(oranges + 5*chicken_drumsticks <= 52)
    model.addConstr(oranges + 5*slices_of_pizza <= 73)
    model.addConstr(4*milkshakes + 5*slices_of_pizza <= 78)
    model.addConstr(4*milkshakes + 5*slices_of_pizza + 5*chicken_drumsticks <= 54)
    model.addConstr(4*milkshakes + oranges + 5*slices_of_pizza + 5*chicken_drumsticks <= 54)
    model.addConstr(3*slices_of_pizza + 4*chicken_drumsticks <= 79)
    model.addConstr(5*oranges + 3*slices_of_pizza <= 61)
    model.addConstr(3*milkshakes + 4*chicken_drumsticks <= 78)
    model.addConstr(3*milkshakes + 3*slices_of_pizza <= 38)
    model.addConstr(3*milkshakes + 5*oranges <= 61)
    model.addConstr(3*milkshakes + 5*oranges + 3*slices_of_pizza + 4*chicken_drumsticks <= 61)
    model.addConstr(2*milkshakes + 2*slices_of_pizza <= 27)
    model.addConstr(2*milkshakes + oranges <= 66)
    model.addConstr(2*slices_of_pizza + 5*chicken_drumsticks <= 37)
    model.addConstr(oranges + 2*slices_of_pizza <= 59)
    model.addConstr(oranges + 5*chicken_drumsticks <= 62)
    model.addConstr(2*milkshakes + oranges + 5*chicken_drumsticks <= 49)
    model.addConstr(2*milkshakes + 2*slices_of_pizza + 5*chicken_drumsticks <= 40)
    model.addConstr(2*milkshakes + oranges + 2*slices_of_pizza + 5*chicken_drumsticks <= 40)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Milkshakes: ", milkshakes.varValue)
        print("Oranges: ", oranges.varValue)
        print("Slices of Pizza: ", slices_of_pizza.varValue)
        print("Chicken Drumsticks: ", chicken_drumsticks.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
