
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_c = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_c")
    vitamin_b1 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b1")
    vitamin_b6 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")
    zinc = m.addVar(vtype=gp.GRB.INTEGER, name="zinc")

    # Set objective function
    m.setObjective(3 * vitamin_c + 1 * vitamin_b1 + 9 * vitamin_b6 + 9 * zinc, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7 * vitamin_c + 1 * vitamin_b1 >= 26)
    m.addConstr(7 * vitamin_c + 7 * zinc >= 38)
    m.addConstr(7 * vitamin_c + 1 * vitamin_b1 + 8 * vitamin_b6 + 7 * zinc >= 38)
    m.addConstr(11 * vitamin_b6 + 3 * zinc >= 22)
    m.addConstr(8 * vitamin_c + 6 * vitamin_b1 >= 23)
    m.addConstr(6 * vitamin_b1 + 11 * vitamin_b6 + 3 * zinc >= 21)
    m.addConstr(8 * vitamin_c + 6 * vitamin_b1 + 3 * zinc >= 21)
    m.addConstr(8 * vitamin_c + 11 * vitamin_b6 + 3 * zinc >= 21)
    m.addConstr(6 * vitamin_b1 + 11 * vitamin_b6 + 3 * zinc >= 20)
    m.addConstr(8 * vitamin_c + 6 * vitamin_b1 + 3 * zinc >= 20)
    m.addConstr(8 * vitamin_c + 11 * vitamin_b6 + 3 * zinc >= 20)
    m.addConstr(6 * vitamin_b1 + 11 * vitamin_b6 + 3 * zinc >= 12)
    m.addConstr(8 * vitamin_c + 6 * vitamin_b1 + 3 * zinc >= 12)
    m.addConstr(8 * vitamin_c + 11 * vitamin_b6 + 3 * zinc >= 12)
    m.addConstr(8 * vitamin_c + 6 * vitamin_b1 + 11 * vitamin_b6 + 3 * zinc >= 12)
    m.addConstr(6 * vitamin_b1 + 11 * vitamin_b6 >= 18)
    m.addConstr(8 * vitamin_c + 11 * vitamin_b6 >= 21)
    m.addConstr(11 * vitamin_b6 + 7 * zinc >= 33)
    m.addConstr(8 * vitamin_c + 6 * vitamin_b1 + 11 * vitamin_b6 + 7 * zinc >= 33)
    m.addConstr(1 * vitamin_c - 8 * vitamin_b1 >= 0)
    m.addConstr(7 * vitamin_c + 7 * zinc <= 61)
    m.addConstr(7 * vitamin_c + 8 * vitamin_b6 <= 133)
    m.addConstr(8 * vitamin_b6 + 7 * zinc <= 89)
    m.addConstr(8 * vitamin_c + 3 * zinc <= 41)
    m.addConstr(8 * vitamin_c + 6 * vitamin_b1 <= 39)
    m.addConstr(6 * vitamin_b1 + 11 * vitamin_b6 <= 89)
    m.addConstr(8 * vitamin_c + 11 * vitamin_b6 + 3 * zinc <= 24)
    m.addConstr(6 * vitamin_b1 + 11 * vitamin_b6 + 7 * zinc <= 92)


    # Resource Constraints
    m.addConstr(7 * vitamin_c <= 201)
    m.addConstr(8 * vitamin_c <= 92)
    m.addConstr(8 * vitamin_c <= 141)
    m.addConstr(1 * vitamin_b1 <= 201)
    m.addConstr(6 * vitamin_b1 <= 92)
    m.addConstr(6 * vitamin_b1 <= 141)
    m.addConstr(8 * vitamin_b6 <= 201)
    m.addConstr(11 * vitamin_b6 <= 92)
    m.addConstr(11 * vitamin_b6 <= 141)
    m.addConstr(7 * zinc <= 201)
    m.addConstr(3 * zinc <= 92)
    m.addConstr(7 * zinc <= 141)



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
