
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("diet_problem")

# Create variables
steaks = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="steaks")
kale_salads = m.addVar(lb=0, vtype=GRB.INTEGER, name="kale_salads")


# Set objective function
m.setObjective(3 * steaks + 8 * kale_salads, GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * steaks + 2 * kale_salads >= 28, "protein_min")
m.addConstr(8 * steaks + 1 * kale_salads >= 20, "healthiness_min")
m.addConstr(-9 * steaks + 9 * kale_salads >= 0, "steak_kale_ratio")
m.addConstr(7 * steaks + 2 * kale_salads <= 58, "protein_max")
m.addConstr(8 * steaks + 1 * kale_salads <= 27, "healthiness_max")



# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")

