
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="steaks")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="kale_salads")

# Define the objective function
m.setObjective(3*x0 + 8*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(7*x0 + 2*x1 >= 28, "protein_min")
m.addConstr(8*x0 + x1 >= 20, "healthiness_min")
m.addConstr(-9*x0 + 9*x1 >= 0, "steaks_vs_salads")
m.addConstr(7*x0 + 2*x1 <= 58, "protein_max")
m.addConstr(8*x0 + x1 <= 27, "healthiness_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Steaks: {x0.x}")
    print(f"Kale Salads: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
