
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    steaks = model.addVar(name="steaks", lb=0)  # Non-integer, non-negative
    kale_salads = model.addVar(name="kale_salads", lb=0, integrality=gurobi.GRB.INTEGER)  # Integer, non-negative

    # Define the objective function
    model.setObjective(3 * steaks + 8 * kale_salads, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7 * steaks + 2 * kale_salads >= 28)
    model.addConstr(8 * steaks + kale_salads >= 20)
    model.addConstr(-9 * steaks + 9 * kale_salads >= 0)
    model.addConstr(7 * steaks + 2 * kale_salads <= 58)
    model.addConstr(8 * steaks + kale_salads <= 27)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Steaks: {steaks.varValue}")
        print(f"Kale Salads: {kale_salads.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
