
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["apple pies", "steaks", "cherry pies", "bowls of cereal", "blueberry pies"])


# Set objective function
m.setObjective(7.7 * x[0] + 7.66 * x[1] + 1.88 * x[2] + 6.21 * x[3] + 8.43 * x[4], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x[0] + 15*x[1] + 15*x[2] + 5*x[3] + 14*x[4] <= 451, "r0")
m.addConstr(15*x[1] + 14*x[4] >= 65, "c1")
m.addConstr(8*x[0] + 5*x[3] >= 49, "c2")
m.addConstr(15*x[2] + 5*x[3] >= 39, "c3")
m.addConstr(15*x[1] + 5*x[3] >= 36, "c4")
m.addConstr(8*x[0] + 15*x[1] + 5*x[3] >= 71, "c5")
m.addConstr(8*x[0] + 15*x[1] + 15*x[2] >= 71, "c6")
m.addConstr(8*x[0] + 15*x[2] + 5*x[3] >= 71, "c7")
m.addConstr(15*x[2] + 5*x[3] + 14*x[4] >= 71, "c8")
m.addConstr(8*x[0] + 5*x[3] + 14*x[4] >= 71, "c9")
m.addConstr(15*x[1] + 5*x[3] + 14*x[4] >= 71, "c10")
m.addConstr(8*x[0] + 15*x[2] + 14*x[4] >= 71, "c11")

# ... (rest of the constraints - see full code in the following section)

m.addConstr(9*x[0] - 4*x[2] - 2*x[3] >= 0, "c47")
m.addConstr(15*x[2] + 14*x[4] <= 260, "c48")
m.addConstr(15*x[2] + 5*x[3] <= 384, "c49")
m.addConstr(5*x[3] + 14*x[4] <= 189, "c50")
m.addConstr(8*x[0] + 14*x[4] <= 219, "c51")
m.addConstr(15*x[1] + 5*x[3] <= 443, "c52")
m.addConstr(8*x[0] + 5*x[3] <= 105, "c53")
m.addConstr(15*x[1] + 15*x[2] <= 299, "c54")
m.addConstr(8*x[0] + 15*x[1] + 15*x[2] + 5*x[3] + 14*x[4] <= 299, "c55")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

