
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
carbs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbs")
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
iron = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="iron")
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")

# Set objective function
m.setObjective(1.73 * carbs + 6.73 * calcium + 6.03 * iron + 3.16 * vitamin_b5, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5.15 * iron + 0.68 * vitamin_b5 >= 11)
m.addConstr(5.42 * carbs + 0.68 * vitamin_b5 >= 18)
m.addConstr(9.63 * calcium + 5.15 * iron >= 14)
m.addConstr(5.42 * carbs + 9.63 * calcium >= 7)
m.addConstr(9.63 * calcium + 5.15 * iron + 0.68 * vitamin_b5 >= 9)
m.addConstr(5.42 * carbs + 9.63 * calcium + 5.15 * iron >= 9)
m.addConstr(5.42 * carbs + 9.63 * calcium + 0.68 * vitamin_b5 >= 9)
m.addConstr(5.42 * carbs + 5.15 * iron + 0.68 * vitamin_b5 >= 9)
m.addConstr(9.63 * calcium + 5.15 * iron + 0.68 * vitamin_b5 >= 16)
m.addConstr(5.42 * carbs + 9.63 * calcium + 5.15 * iron >= 16)
m.addConstr(5.42 * carbs + 9.63 * calcium + 0.68 * vitamin_b5 >= 16)
m.addConstr(5.42 * carbs + 5.15 * iron + 0.68 * vitamin_b5 >= 16)
m.addConstr(9.63 * calcium + 5.15 * iron + 0.68 * vitamin_b5 >= 14)
m.addConstr(5.42 * carbs + 9.63 * calcium + 5.15 * iron >= 14)
m.addConstr(5.42 * carbs + 9.63 * calcium + 0.68 * vitamin_b5 >= 14)
m.addConstr(5.42 * carbs + 5.15 * iron + 0.68 * vitamin_b5 >= 14)
m.addConstr(9.63 * calcium + 5.15 * iron + 0.68 * vitamin_b5 >= 11)
m.addConstr(5.42 * carbs + 9.63 * calcium + 5.15 * iron >= 11)
m.addConstr(5.42 * carbs + 9.63 * calcium + 0.68 * vitamin_b5 >= 11)
m.addConstr(5.42 * carbs + 5.15 * iron + 0.68 * vitamin_b5 >= 11)
m.addConstr(5.42 * carbs + 9.63 * calcium + 5.15 * iron + 0.68 * vitamin_b5 >= 11)
m.addConstr(5.9 * carbs + 4.99 * vitamin_b5 >= 34)
m.addConstr(4.43 * calcium + 4.99 * vitamin_b5 >= 45)
m.addConstr(7.38 * iron + 4.99 * vitamin_b5 >= 49)
m.addConstr(5.9 * carbs + 7.38 * iron >= 18)
m.addConstr(4.43 * calcium + 7.38 * iron >= 25)
m.addConstr(5.9 * carbs + 4.43 * calcium + 7.38 * iron >= 45)
m.addConstr(5.9 * carbs + 4.43 * calcium + 7.38 * iron + 4.99 * vitamin_b5 >= 45)
m.addConstr(3.17 * calcium + 2.71 * vitamin_b5 >= 15)
m.addConstr(2.23 * carbs + 3.17 * calcium >= 28)
m.addConstr(2.23 * carbs + 1.19 * iron >= 11)
m.addConstr(2.23 * carbs + 3.17 * calcium + 1.19 * iron >= 28)
m.addConstr(2.23 * carbs + 3.17 * calcium + 1.19 * iron + 2.71 * vitamin_b5 >= 28)
m.addConstr(-6 * calcium + 8 * vitamin_b5 >= 0)
m.addConstr(5.42 * carbs + 0.68 * vitamin_b5 <= 69)
m.addConstr(9.63 * calcium + 5.15 * iron <= 20)
m.addConstr(5.42 * carbs + 5.15 * iron + 0.68 * vitamin_b5 <= 40)
m.addConstr(9.63 * calcium + 5.15 * iron + 0.68 * vitamin_b5 <= 23)
m.addConstr(5.9 * carbs + 7.38 * iron <= 90)
m.addConstr(7.38 * iron + 4.99 * vitamin_b5 <= 114)
m.addConstr(5.9 * carbs + 4.99 * vitamin_b5 <= 134)
m.addConstr(5.9 * carbs + 4.43 * calcium <= 148)
m.addConstr(3.17 * calcium + 1.19 * iron <= 65)
m.addConstr(2.23 * carbs + 3.17 * calcium + 1.19 * iron <= 99)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

