
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="x0")  # packs of paper plates
x1 = m.addVar(vtype=GRB.INTEGER, name="x1")  # bottles of ibuprofen
x2 = m.addVar(vtype=GRB.INTEGER, name="x2")  # toilet paper rolls
x3 = m.addVar(vtype=GRB.INTEGER, name="x3")  # diapers
x4 = m.addVar(vtype=GRB.INTEGER, name="x4")  # cartons of milk


# Set objective function
m.setObjective(3.08*x0**2 + 5.45*x0*x1 + 3.4*x0*x2 + 4.05*x0*x3 + 5.91*x0*x4 + 2.46*x1**2 + 9.62*x1*x2 + 8.76*x1*x3 + 2.2*x2**2 + 3.71*x3**2 + 5.58*x4**2 + 5.18*x0 + 7.76*x1 + 3.37*x2 + 5.99*x3 + 8.27*x4, GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x2**2 + 8*x3**2 >= 26)
m.addConstr(2*x0 + 8*x3 >= 16)
m.addConstr(2*x0 + 6*x4 >= 18)
m.addConstr(2*x0 + 11*x2 >= 46)
m.addConstr(2*x0 + 3*x1 + 11*x2 + 8*x3 + 6*x4 >= 46)
m.addConstr(10*x0**2 + 5*x4**2 >= 27)
m.addConstr(10*x0 + 8*x2 >= 40)
m.addConstr(6*x1**2 + 5*x4**2 >= 19)
m.addConstr(8*x2 + 5*x4 >= 40)
m.addConstr(6*x1 + 9*x3 >= 42)
m.addConstr(10*x0**2 + 8*x2**2 + 9*x3**2 >= 37)
m.addConstr(10*x0 + 6*x1 + 8*x2 + 9*x3 + 5*x4 >= 37)
m.addConstr(-3*x1**2 + 10*x3**2 >= 0)
m.addConstr(3*x1**2 - 4*x2**2 >= 0)
m.addConstr(2*x0**2 + 11*x2**2 + 6*x4**2 <= 118)
m.addConstr(11*x2**2 + 8*x3**2 + 6*x4**2 <= 111)
m.addConstr(2*x0**2 + 3*x1**2 + 6*x4**2 <= 194)
m.addConstr(3*x1**2 + 11*x2**2 + 8*x3**2 <= 202)
m.addConstr(2*x0**2 + 8*x3**2 + 6*x4**2 <= 203)
m.addConstr(2*x0 + 3*x1 + 11*x2 <= 232)
m.addConstr(6*x1 + 9*x3 <= 109)
m.addConstr(6*x1 + 8*x2 + 5*x4 <= 119)
m.addConstr(10*x0 + 6*x1 + 8*x2 <= 209)
m.addConstr(10*x0**2 + 8*x2**2 + 9*x3**2 <= 153)
m.addConstr(8*x2 + 9*x3 + 5*x4 <= 156)
m.addConstr(10*x0 + 6*x1 + 5*x4 <= 160)
m.addConstr(10*x0 + 8*x2 + 5*x4 <= 182)
m.addConstr(6*x1 + 9*x3 + 5*x4 <= 204)
m.addConstr(2*x0 + 3*x1 + 11*x2 + 8*x3 + 6*x4 <= 245)  # r0
m.addConstr(10*x0 + 6*x1 + 8*x2 + 9*x3 + 5*x4 <= 221) # r1


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

