
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, vtype=gp.GRB.INTEGER, name=["milkshakes", "knishes", "rotisserie chickens", "chicken drumsticks", "granola bars"])


# Set objective function
m.setObjective(5.26 * x[0] + 6.92 * x[1] + 7.49 * x[2] + 2.48 * x[3] + 4.42 * x[4], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9.41 * x[1] + 6.14 * x[4] >= 43)
m.addConstr(9.41 * x[0] + 4.02 * x[1] >= 74)
m.addConstr(9.41 * x[0] + 6.14 * x[4] >= 37)
m.addConstr(0.18 * x[2] + 7.23 * x[3] >= 70)
m.addConstr(9.41 * x[0] + 0.18 * x[2] + 6.14 * x[4] >= 59)
m.addConstr(0.18 * x[2] + 7.23 * x[3] + 6.14 * x[4] >= 59)
m.addConstr(9.41 * x[0] + 0.18 * x[2] + 7.23 * x[3] >= 59)
m.addConstr(9.41 * x[0] + 0.18 * x[2] + 6.14 * x[4] >= 76)
m.addConstr(0.18 * x[2] + 7.23 * x[3] + 6.14 * x[4] >= 76)
m.addConstr(9.41 * x[0] + 0.18 * x[2] + 7.23 * x[3] >= 76)
m.addConstr(9.41 * x[0] + 0.18 * x[2] + 6.14 * x[4] >= 44)
m.addConstr(0.18 * x[2] + 7.23 * x[3] + 6.14 * x[4] >= 44)
m.addConstr(9.41 * x[0] + 0.18 * x[2] + 7.23 * x[3] >= 44)
m.addConstr(9.41 * x[0] + 4.02 * x[1] + 0.18 * x[2] + 7.23 * x[3] + 6.14 * x[4] >= 44)

m.addConstr(1.22 * x[0] + 7.39 * x[1] >= 43)
m.addConstr(7.39 * x[1] + 2.44 * x[3] >= 48)
m.addConstr(7.39 * x[1] + 0.14 * x[4] >= 40)
m.addConstr(1.22 * x[0] + 2.44 * x[3] >= 43)
m.addConstr(2.44 * x[3] + 0.14 * x[4] >= 48)
m.addConstr(8.83 * x[2] + 0.14 * x[4] >= 28)
m.addConstr(1.22 * x[0] + 8.83 * x[2] >= 30)
m.addConstr(1.22 * x[0] + 2.44 * x[3] + 0.14 * x[4] >= 59)
m.addConstr(1.22 * x[0] + 7.39 * x[1] + 8.83 * x[2] + 2.44 * x[3] + 0.14 * x[4] >= 59)


m.addConstr(6.65 * x[3] + 5.77 * x[4] >= 38)
m.addConstr(4.19 * x[1] + 6.65 * x[3] >= 32)
m.addConstr(4.19 * x[1] + 5.77 * x[4] >= 66)
m.addConstr(7.68 * x[0] + 7.22 * x[2] >= 23)
m.addConstr(7.68 * x[0] + 5.77 * x[4] >= 47)
m.addConstr(4.19 * x[1] + 7.22 * x[2] >= 63)
m.addConstr(7.68 * x[0] + 4.19 * x[1] + 7.22 * x[2] + 6.65 * x[3] + 5.77 * x[4] >= 63)

m.addConstr(3.55 * x[0] + 1.06 * x[2] >= 36)
m.addConstr(3.55 * x[0] + 4.49 * x[1] >= 26)
m.addConstr(4.49 * x[1] + 9.66 * x[4] >= 62)
m.addConstr(3.55 * x[0] + 4.49 * x[1] + 1.06 * x[2] + 1.35 * x[3] + 9.66 * x[4] >= 62)

m.addConstr(10 * x[1] - x[2] >= 0)
m.addConstr(-10 * x[1] + 2 * x[4] >= 0)
m.addConstr(-8 * x[2] - 3 * x[3] + 8 * x[4] >= 0)

m.addConstr(2.44 * x[3] + 0.14 * x[4] <= 69)
m.addConstr(6.65 * x[3] + 5.77 * x[4] <= 174)
m.addConstr(4.19 * x[1] + 7.22 * x[2] <= 205)
m.addConstr(7.68 * x[0] + 7.22 * x[2] + 5.77 * x[4] <= 130)
m.addConstr(4.19 * x[1] + 6.65 * x[3] + 5.77 * x[4] <= 145)

m.addConstr(4.49 * x[1] + 9.66 * x[4] <= 281)
m.addConstr(3.55 * x[0] + 1.06 * x[2] + 1.35 * x[3] <= 73)
m.addConstr(1.06 * x[2] + 1.35 * x[3] + 9.66 * x[4] <= 291)
m.addConstr(3.55 * x[0] + 4.49 * x[1] + 9.66 * x[4] <= 101)
m.addConstr(3.55 * x[0] + 1.35 * x[3] + 9.66 * x[4] <= 222)
m.addConstr(3.55 * x[0] + 4.49 * x[1] + 1.35 * x[3] <= 246)
m.addConstr(4.49 * x[1] + 1.06 * x[2] + 1.35 * x[3] <= 338)


r0 = 9.41 * x[0] + 4.02 * x[1] + 0.18 * x[2] + 7.23 * x[3] + 6.14 * x[4]
r1 = 1.22 * x[0] + 7.39 * x[1] + 8.83 * x[2] + 2.44 * x[3] + 0.14 * x[4]
r2 = 7.68 * x[0] + 4.19 * x[1] + 7.22 * x[2] + 6.65 * x[3] + 5.77 * x[4]
r3 = 3.55 * x[0] + 4.49 * x[1] + 1.06 * x[2] + 1.35 * x[3] + 9.66 * x[4]

m.addConstr(r0 <= 396)
m.addConstr(r1 <= 303)
m.addConstr(r2 <= 331)
m.addConstr(r3 <= 347)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

