
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="black_beans", lb=0)
x1 = m.addVar(name="cheeseburgers", lb=0)
x2 = m.addVar(name="protein_bars", lb=0)
x3 = m.addVar(name="granola_bars", lb=0)
x4 = m.addVar(name="cherry_pies", lb=0)

# Define the objective function
m.setObjective(8*x0 + 8*x1 + 2*x2 + 5*x3 + 8*x4, gurobi.GRB.MINIMIZE)

# Add constraints
# Sourness Index Constraints
m.addConstr(5.35*x0 + 5.48*x4 >= 12)
m.addConstr(5.74*x1 + 7.71*x2 >= 25)
m.addConstr(5.35*x0 + 5.74*x1 >= 22)
m.addConstr(5.35*x0 + 3.42*x3 >= 28)
m.addConstr(5.74*x1 + 5.48*x4 >= 27)
m.addConstr(3.42*x3 + 5.48*x4 >= 24)
m.addConstr(7.71*x2 + 3.42*x3 >= 30)
m.addConstr(5.35*x0 + 5.74*x1 + 7.71*x2 + 3.42*x3 + 5.48*x4 >= 30)

# Umami Index Constraints
m.addConstr(1.55*x1 + 7.39*x4 >= 20)
m.addConstr(5.65*x2 + 7.87*x3 >= 17)
m.addConstr(7.76*x0 + 1.55*x1 >= 35)
m.addConstr(7.76*x0 + 5.65*x2 >= 39)
m.addConstr(7.87*x3 + 7.39*x4 >= 38)
m.addConstr(7.76*x0 + 7.39*x4 >= 34)
m.addConstr(1.55*x1 + 5.65*x2 + 7.39*x4 >= 49)
m.addConstr(7.76*x0 + 5.65*x2 + 7.87*x3 >= 49)
m.addConstr(1.55*x1 + 7.87*x3 + 7.39*x4 >= 49)
m.addConstr(7.76*x0 + 1.55*x1 + 7.39*x4 >= 49)
m.addConstr(7.76*x0 + 7.87*x3 + 7.39*x4 >= 49)
m.addConstr(7.76*x0 + 1.55*x1 + 5.65*x2 >= 49)

# Calcium Constraints
m.addConstr(7.87*x0 + 1.63*x2 >= 42)
m.addConstr(7.07*x3 + 7.97*x4 >= 23)
m.addConstr(1.63*x2 + 7.97*x4 >= 48)
m.addConstr(1.63*x2 + 7.07*x3 >= 49)
m.addConstr(6.7*x1 + 1.63*x2 >= 55)
m.addConstr(1.63*x2 + 7.07*x3 + 7.97*x4 >= 50)
m.addConstr(6.7*x1 + 1.63*x2 + 7.07*x3 >= 50)
m.addConstr(7.87*x0 + 6.7*x1 + 7.97*x4 >= 50)
m.addConstr(7.87*x0 + 7.07*x3 + 7.97*x4 >= 50)
m.addConstr(7.87*x0 + 6.7*x1 + 1.63*x2 >= 50)

# Other Constraints
m.addConstr(-3*x3 + 2*x4 >= 0)
m.addConstr(2*x0 - 5*x2 >= 0)
m.addConstr(5.74*x1 + 7.71*x2 <= 46)
m.addConstr(5.74*x1 + 3.42*x3 <= 125)
m.addConstr(7.71*x2 + 5.48*x4 <= 136)
m.addConstr(3.42*x3 + 5.48*x4 <= 46)
m.addConstr(5.35*x0 + 7.71*x2 <= 59)
m.addConstr(5.74*x1 + 3.42*x3 + 5.48*x4 <= 72)
m.addConstr(5.74*x1 + 7.71*x2 + 3.42*x3 <= 160)
m.addConstr(5.35*x0 + 3.42*x3 + 5.48*x4 <= 143)
m.addConstr(5.74*x1 + 7.71*x2 + 5.48*x4 <= 167)
m.addConstr(5.35*x0 + 5.74*x1 + 3.42*x3 <= 46)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Black beans: ", x0.varValue)
    print("Cheeseburgers: ", x1.varValue)
    print("Protein bars: ", x2.varValue)
    print("Granola bars: ", x3.varValue)
    print("Cherry pies: ", x4.varValue)
else:
    print("No optimal solution found")
