
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0, name=["Peggy", "Laura", "Mary", "Paul", "John"])

# Set integer constraints
x[0].vtype = gp.GRB.INTEGER
x[2].vtype = gp.GRB.INTEGER


# Set objective function
m.setObjective(6*x[0] + 7*x[1] + 5*x[2] + 6*x[3] + 3*x[4], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9.62*x[0] + 1.47*x[2] + 4.47*x[4] >= 28)
m.addConstr(9.62*x[0] + 13.34*x[1] + 1.47*x[2] >= 28)
m.addConstr(13.34*x[1] + 2.35*x[3] + 4.47*x[4] >= 28)
m.addConstr(1.47*x[2] + 2.35*x[3] + 4.47*x[4] >= 28)
m.addConstr(9.62*x[0] + 1.47*x[2] + 4.47*x[4] >= 32)
m.addConstr(9.62*x[0] + 13.34*x[1] + 1.47*x[2] >= 32)
m.addConstr(13.34*x[1] + 2.35*x[3] + 4.47*x[4] >= 32)
m.addConstr(1.47*x[2] + 2.35*x[3] + 4.47*x[4] >= 32)
m.addConstr(9.62*x[0] + 1.47*x[2] + 4.47*x[4] >= 34)
m.addConstr(9.62*x[0] + 13.34*x[1] + 1.47*x[2] >= 34)
m.addConstr(13.34*x[1] + 2.35*x[3] + 4.47*x[4] >= 34)
m.addConstr(1.47*x[2] + 2.35*x[3] + 4.47*x[4] >= 34)
m.addConstr(9.62*x[0] + 1.47*x[2] + 4.47*x[4] >= 34)
m.addConstr(9.62*x[0] + 13.34*x[1] + 1.47*x[2] >= 34)
m.addConstr(13.34*x[1] + 2.35*x[3] + 4.47*x[4] >= 34)
m.addConstr(1.47*x[2] + 2.35*x[3] + 4.47*x[4] >= 34)
m.addConstr(8.9*x[0] + 5.03*x[4] >= 36)
m.addConstr(12.81*x[2] + 5.12*x[3] >= 36)
m.addConstr(1.15*x[1] + 12.81*x[2] >= 14)
m.addConstr(8.9*x[0] + 12.81*x[2] >= 37)
m.addConstr(8.9*x[0] + 5.12*x[3] + 5.03*x[4] >= 30)
m.addConstr(12.81*x[2] + 5.12*x[3] + 5.03*x[4] >= 30)
m.addConstr(8.9*x[0] + 1.15*x[1] + 5.03*x[4] >= 30)
m.addConstr(8.9*x[0] + 1.15*x[1] + 5.12*x[3] >= 30)
m.addConstr(8.9*x[0] + 1.15*x[1] + 12.81*x[2] >= 30)
m.addConstr(1.15*x[1] + 12.81*x[2] + 5.12*x[3] >= 30)
m.addConstr(8.9*x[0] + 12.81*x[2] + 5.03*x[4] >= 30)


# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Obj: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

