
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("maximize_food")

    # Create variables
    cornichons = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")
    bacon = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bacon")
    pizza = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="pizza")


    # Set objective function
    model.setObjective(7 * cornichons + 1 * bacon + 1 * pizza, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7 * cornichons + 6 * bacon <= 22, "fiber_constraint1")
    model.addConstr(7 * cornichons + 1 * pizza <= 22, "fiber_constraint2")
    model.addConstr(7 * cornichons + 6 * bacon + 1 * pizza <= 23, "fiber_constraint3")
    model.addConstr(7 * cornichons + 6 * bacon + 1 * pizza <= 23, "fiber_constraint4") # Redundant constraint


    # Optimize model
    model.optimize()

    # Print results
    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('cornichons:', cornichons.x)
        print('bacon:', bacon.x)
        print('pizza:', pizza.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

