
from gurobi import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="cornichons")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="strips_of_bacon")
x3 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="slices_of_pizza")

# Set the objective function
m.setObjective(7*x1 + x2 + x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 6*x2 <= 22, "fiber_from_cornichons_and_bacon")
m.addConstr(7*x1 + x3 <= 22, "fiber_from_cornichons_and_pizza")
m.addConstr(7*x1 + 6*x2 + x3 <= 23, "total_fiber")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"cornichons: {x1.x}")
    print(f"strips_of_bacon: {x2.x}")
    print(f"slices_of_pizza: {x3.x}")
else:
    print("No optimal solution found")
